## PR Type

What kind of pull request is this? Put an `x` in all the boxes that apply:

- [ ] Bug fix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Extend feature (non-breaking change which extends existing functionality)
- [ ] Change feature (non-breaking change which either changes or refactors existing functionality)
- [ ] Breaking change (fix or feature that would cause existing functionality to change)

## What does it change?

Describe your changes in detail.

## Why this PR?

Why is this change required? What problem does it solve?

## How has this been tested?

Please describe in detail how you tested your changes (or are planning on testing them).

## Checklist

To facilitate merging your change and the approval of this PR, please make sure you've reviewed and applied the following:

- This PR addresses exactly one issue
- All changes were made in a fork of this project (preferably also in a separate branch)
- It follows the code style of this project
- Tests were added to cover the changes
- All previously existing tests still pass
- If the change to the code requires a change to the documentation, it has been updated accordingly

If you're unsure about any of these, don't hesitate to ask. We're here to help!
