# Contributing

Contributions are very welcome and will be fully credited.

We accept contributions via pull requests.

## Pull request guidelines

- **[PSR-2 Coding Standard](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-2-coding-style-guide.md)** - Don't go crazy with the formatting.

- **Add tests** - Your patch won't be accepted if it doesn't have tests. Don't worry though! Feel free to submit a PR without, we'll help you along the way.

- **Document any change in behaviour** - Make sure the `README.md` and any other relevant documentation are kept up-to-date.

- **Consider our release cycle** - We try to follow [SemVer v2.0.0](http://semver.org/). Randomly breaking public APIs is not an option.

- **Create feature branches** - Don't ask us to pull from your master branch unless it only contains the PR code.

- **One pull request per feature** - If you want to do more than one thing, send multiple pull requests.

- **Send coherent history** - Make sure each commit in your pull request is somewhat meaningful and contains related changes. Don't go overboard by changing a dozen files and doing everything in a single commit.
