<?php

namespace NovaButton\Providers;

use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use Laravel\Nova\Events\ServingNova;
use Laravel\Nova\Nova;

class FieldServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->publishes([
            __DIR__.'/../../config/nova-button.php' => config_path('nova-button.php'),
        ], 'nova-button');

        Nova::serving(function (ServingNova $event) {
            Nova::script('nova-button', __DIR__.'/../../dist/js/field.js');
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(__DIR__.'/../../config/nova-button.php', 'nova-button');

        $this->registerRoutes();
    }

    /**
     * Registers field routes.
     *
     * @return void
     */
    private function registerRoutes()
    {
        Route::middleware(['nova'])
             ->prefix('nova-vendor/nova-button')
             ->group(__DIR__.'/../../routes/api.php');
    }
}
